// Configuration for 修修助手
// You can modify the values below to change the application text.

window.AppConfig = {
    // The main product name displayed in the title and header
    productName: "修修助手",
    productSubtitle: "请选择检测模式开始AI分析",

    // Menu Item Names and Descriptions
    menuItems: {
        detection: {
            title: "修修检测",
            desc: "上传照片分析磨损与状态" // Dynamic description
        },
        encyclopedia: {
            title: "修修百科",
            desc: "智能识别车辆电路结构" // Dynamic description
        }
    },

    // The text simulated during the voice recognition in the Encyclopedia screen
    // Voice Interaction Dialogues (Multiple Rounds support)
    // each item represents a round of interaction: { text: "...", image: "..." }
    dialogues: [
        {
            text: "请帮我查询东风新580 2022款,电子稳定性系统电路图",
            image: "circuit.jpg"
        },
        {
            text: "请帮我将这张电路图精确到左前轮速传感器与esp连接部分",
            image: "circuit2.jpg"
        }
    ],
    
    // Typing speed for voice text simulation (seconds per character)
    voiceTypingSpeed: 0.1,
    // Duration of the "loading spinner" after voice input (seconds)
    voiceProcessingDuration: 0.15, // Default 0.15s per user request (was 3.0s)

    // Configuration for Report Fonts
    // Configuration for Main Interface Fonts (rem)
    fontSizes: {
        productTitle: 6.0,   // "修修助手" Title Size
        productSubtitle: 2.4, // "请选择检测模式开始AI分析" Subtitle Size
        menuTitle: 2.4,      // "修修检测" Menu Title Size
        menuTitle: 2.4,      // "修修检测" Menu Title Size
        menuDesc: 1.8,       // "上传照片分析磨损与状态" Menu Desc Size
        logoHeight: 150      // Logo height in pixels
    },

    // Configuration for Repair Detection (Endoscope UI)
    repairDetection: {
        reportTitle: "修修刹车片AI智能检测报告", // Configurable report screen title
        placeholderTitle: "工业内窥镜已连接",
        statusItems: [
            "SYS: ONLINE", 
            "CAM: 1080P/60FPS", 
            "BAT: 98%"
        ],
        instructions: [
            "请手持内窥镜深入轮毂间隙",
            "避开遮挡，寻找最佳观测点",
            "保持探头稳定 (防抖开启)"
        ],
        analysisDuration: 2, // Simulated analysis duration in seconds
        previewImageHeight: 200, // 预览图片高度 (单位 px)
        
        // Font sizes for the Endoscope UI (values are in 'rem', just enter the number)
        fontSizes: {
            statusBar: 1.2,    // 顶部状态栏文字大小 (如: SYS: ONLINE)
            title: 2.5,        // 中间大标题文字大小 (如: 工业内窥镜已连接)
            steps: 1.5,        // 下方操作指引文字大小 (如: 请手持内窥镜...)
            previewLabel: 1.1, // 预览卡片左侧文字大小 (如: 右前轮)
            previewTime: 0.95  // 预览卡片右侧时间大小
        },
        
        // Wheel images and labels for the simulated collection
        // Order determines the sequence they appear in: Right Front -> Right Rear -> Left Rear -> Left Front
        wheelImages: [
            { id: 1, src: '1.png', label: '右前轮' },
            { id: 2, src: '2.png', label: '右后轮' },
            { id: 3, src: '3.png', label: '左后轮' },
            { id: 4, src: '4.png', label: '左前轮' }
        ],
        // Report Config for Inspection Report Screen
        reportConfig: {
            vehicleInfo: {
                date: "2026-01",
                model: "东风新580",
                mileage: "1314520KM"
            },
            // Comparison Images
            comparisonImages: {
                newPad: "result1.png", // Image for "Data Sample" (Left)
                analyzedPad: "result2.png" // Image for "Analyzed Result" (Right)
            },
            // Fail Scenario Data
            fail: {
                summaryTable: [
                    { item: "左前轮内侧刹车片厚度", result: "已达磨损极限", status: "需立即更换", statusClass: "table-status-bad" },
                    { item: "当前摩擦材料厚度", result: "3mm", status: "严重磨损", statusClass: "table-status-bad" },
                    { item: "对比基准 (新片厚度)", result: "8mm", status: "-", statusClass: "table-status-neutral" }
                ],
                recommendations: [
                    { label: "1. 立即更换:", text: "左前轮刹车片厚度 (3mm) 已低于安全阈值，需立即更换，且左、右后轮需成对更换以保持制动平衡。" },
                    { label: "2. 检查关联部件:", text: "更换时检查刹车盘是否磨损或变形，必要时修复或更换。" },
                    { label: "3. 排查潜在故障:", text: "检查卡钳导向销润滑及分泵活塞回位情况，排除异常磨损隐患。" },
                    { label: "4. 规范磨合:", text: "新刹车片更换后需温和驾驶约200公里，避免急刹，确保与刹车盘充分磨合。" }
                ]
            },
            // Pass Scenario Data
            pass: {
                summaryTable: [
                    { item: "左前轮内侧刹车片厚度", result: "磨损正常", status: "状态良好", statusClass: "table-status-neutral" },
                    { item: "当前摩擦材料厚度", result: "8.5mm", status: "无需更换", statusClass: "table-status-neutral" },
                    { item: "对比基准 (新片厚度)", result: "9mm", status: "-", statusClass: "table-status-neutral" }
                ],
                recommendations: [
                    { label: "1. 状态良好:", text: "刹车片厚度充足 (8.5mm)，远高于安全阈值，无需更换。" },
                    { label: "2. 定期检查:", text: "建议每 5000 公里或 6 个月进行一次常规检查。" },
                    { label: "3. 驾驶建议:", text: "保持良好驾驶习惯，避免频繁急刹车，可延长刹车片寿命。" },
                    { label: "4. 观察异响:", text: "如行驶中出现尖锐异响，请及时进站检查。" }
                ]
            }
        }
    }
};
